class CTF_SB extends TDM_SB;

var() texture FlagIcon[4];

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL;
	local font CanvasFont;

	Super.DrawNameAndPing(Canvas, PRI, XOffset, YOffset, bCompressed);
	if ( PRI.HasFlag == None )
		return;

	// Flag icon
	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	if ( CTFFlag(PRI.HasFlag).Team == 0)
		Canvas.SetPos(Canvas.ClipX * 0.5 - FrameBorder, YOffset);
	else
		Canvas.SetPos(XOffset, YOffset);
		
	Canvas.DrawIcon(FlagIcon[CTFFlag(PRI.HasFlag).Team], 1.0);
}

defaultproperties
{
     FlagIcon(0)=Texture'Botpack.Icons.RedFlag'
     FlagIcon(1)=Texture'Botpack.Icons.BlueFlag'
     FlagIcon(2)=Texture'Botpack.Icons.GreenFlag'
     FlagIcon(3)=Texture'Botpack.Icons.YellowFlag'
     FragGoal="Capture Limit:"
}
